unit VCTRAN32;{24 Sept 2000, 4:00:10am}

interface

uses WinTypes, VCType32;

function VCLoadVCTRAN32: boolean;
procedure VCFreeVCTRAN32;
procedure VCAcadBlockRead (pName: PChar); stdcall;
procedure VCAcadRead (pN: PChar); stdcall;
procedure VCAcadReadNoPaint (pNameStart: PChar); stdcall;
procedure VCAcadReadWith3D (pName: PChar); stdcall;
procedure VCAcadWriteDWG (pN: PChar); stdcall;
procedure VCAcadWriteDXF (pN: PChar); stdcall;
procedure VCLoadDrawing (var iError: Smallint; pName: PChar; iFileType: Smallint); stdcall;
procedure VCMergeDrawing (var iError: Smallint; pName: PChar; iFileType: Smallint); stdcall;
procedure VCMergeDrawingNoPaint (var iError: Smallint; pInputName: PChar; iFileType: Smallint); stdcall;
procedure VCSaveDrawing (var iError: Smallint; pName: PChar; iFileType: Smallint; tfSaveSelected: WordBool); stdcall;
procedure VCWriteMetafile (pName: PChar; iFileType: Smallint; tfSelectedOnly: WordBool); stdcall;
procedure VCPlaceMetafileOnClipboard (var iError: Smallint; tfSelectedOnly: WordBool); stdcall;

implementation

var hInst: THandle;

function VCLoadVCTRAN32: boolean;
begin
  hInst := LoadLibrary('VCTRAN32.DLL');
  result := hInst <> 0;
end;

procedure VCFreeVCTRAN32;
begin
  if hInst <> 0 then
    FreeLibrary(hInst);
end;

procedure VCAcadBlockRead (pName: PChar);
type TVCProc = procedure (pName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAcadBlockRead');
    if @aproc <> nil then
      aproc(pName);
  end;
end;

procedure VCAcadRead (pN: PChar);
type TVCProc = procedure (pN: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAcadRead');
    if @aproc <> nil then
      aproc(pN);
  end;
end;

procedure VCAcadReadNoPaint (pNameStart: PChar);
type TVCProc = procedure (pNameStart: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAcadReadNoPaint');
    if @aproc <> nil then
      aproc(pNameStart);
  end;
end;

procedure VCAcadReadWith3D (pName: PChar);
type TVCProc = procedure (pName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAcadReadWith3D');
    if @aproc <> nil then
      aproc(pName);
  end;
end;

procedure VCAcadWriteDWG (pN: PChar);
type TVCProc = procedure (pN: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAcadWriteDWG');
    if @aproc <> nil then
      aproc(pN);
  end;
end;

procedure VCAcadWriteDXF (pN: PChar);
type TVCProc = procedure (pN: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAcadWriteDXF');
    if @aproc <> nil then
      aproc(pN);
  end;
end;

procedure VCLoadDrawing (var iError: Smallint; pName: PChar; iFileType: Smallint);
type TVCProc = procedure (var iError: Smallint; pName: PChar; iFileType: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadDrawing');
    if @aproc <> nil then
      aproc(iError, pName, iFileType);
  end;
end;

procedure VCMergeDrawing (var iError: Smallint; pName: PChar; iFileType: Smallint);
type TVCProc = procedure (var iError: Smallint; pName: PChar; iFileType: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMergeDrawing');
    if @aproc <> nil then
      aproc(iError, pName, iFileType);
  end;
end;

procedure VCMergeDrawingNoPaint (var iError: Smallint; pInputName: PChar; iFileType: Smallint);
type TVCProc = procedure (var iError: Smallint; pInputName: PChar; iFileType: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMergeDrawingNoPaint');
    if @aproc <> nil then
      aproc(iError, pInputName, iFileType);
  end;
end;

procedure VCSaveDrawing (var iError: Smallint; pName: PChar; iFileType: Smallint; tfSaveSelected: WordBool);
type TVCProc = procedure (var iError: Smallint; pName: PChar; iFileType: Smallint; tfSaveSelected: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSaveDrawing');
    if @aproc <> nil then
      aproc(iError, pName, iFileType, tfSaveSelected);
  end;
end;

procedure VCWriteMetafile (pName: PChar; iFileType: Smallint; tfSelectedOnly: WordBool);
type TVCProc = procedure (pName: PChar; iFileType: Smallint; tfSelectedOnly: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCWriteMetafile');
    if @aproc <> nil then
      aproc(pName, iFileType, tfSelectedOnly);
  end;
end;

procedure VCPlaceMetafileOnClipboard (var iError: Smallint; tfSelectedOnly: WordBool);
type TVCProc = procedure (var iError: Smallint; tfSelectedOnly: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPlaceMetafileOnClipboard');
    if @aproc <> nil then
      aproc(iError, tfSelectedOnly);
  end;
end;

end.
